@extends('emails.base')

@section('header')
<span style="color: #111827; font-size: 20px; font-weight: 600;">Your Verification PIN Code</span>
@endsection

@section('slot')

<p style="color: #4B5563; font-size: 16px; line-height: 24px; margin-bottom: 24px;">
    We received a request to verify your account. Please use the following verification code within the next 15 minutes:
</p>

<div style="background-color: #F3F4F6; border: 1px solid #E5E7EB; border-radius: 8px; padding: 20px; text-align: center; margin: 24px 0;">
    <span style="color: #111827; font-size: 32px; font-weight: 700; letter-spacing: 0.05em;">{{ $pin }}</span>
</div>

<p style="color: #4B5563; font-size: 14px; line-height: 20px; margin-bottom: 24px;">
    For security reasons:
</p>
<ul style="color: #4B5563; font-size: 14px; line-height: 20px; margin-bottom: 24px; padding-left: 20px;">
    <li style="margin-bottom: 8px;">Do not share this code with anyone</li>
    <li style="margin-bottom: 8px;">Our team will never ask for this code</li>
    <li style="margin-bottom: 8px;">This code expires in 15 minutes</li>
</ul>

<p style="color: #4B5563; font-size: 14px; line-height: 20px; margin-bottom: 24px;">
    If you didn't request this code, please secure your account by changing your password immediately.
</p>

<p style="color: #4B5563; font-size: 16px; line-height: 24px;">
    Thank you,<br>
    <span style="color: #111827; font-weight: 600;">{{ config('app.name') }} Team</span>
</p>

<div style="border-top: 1px solid #E5E7EB; margin-top: 32px; padding-top: 16px;">
    <p style="color: #9CA3AF; font-size: 12px; line-height: 16px;">
        For security purposes, this email was sent to {{ $user->email }}. If you believe you received this in error, please ignore this message.
    </p>
</div>
@endsection
