<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
         Schema::create('vouchers', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete(); // null = global
            $table->foreignId('investment_scheme_id')->constrained()->cascadeOnDelete();

            $table->string('code')->unique();
            $table->unsignedInteger('max_usage')->default(1); // total usage across all users
            $table->unsignedInteger('usage_per_person')->nullable(); // null = unlimited per person

            $table->unsignedInteger('used_count')->default(0); // how many times used globally
            $table->unsignedInteger('discount_value');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vouchers');
    }
};
