<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rentals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('robot_id')->constrained()->onDelete('cascade');
            $table->integer('quantity');
            $table->decimal('amount_per_hour', 10, 2);
            $table->integer('rent_duration_months');
            $table->enum('status', StatusEnum::asArray())->nullable()->default(StatusEnum::PENDING);
            $table->decimal('revenue_generated', 20, 2);
            $table->timestamp('last_revenue_processed_at')->nullable();
            $table->timestamp('next_revenue_at')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rentals');
    }
};
