<?php

use App\Enums\MediaType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePromotionalMaterialsTable extends Migration
{
    public function up()
    {
        Schema::create('promotional_materials', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('media_url');
            $table->enum('media_type', MediaType::asArray());
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('promotional_materials');
    }
}
