<?php

namespace App\Services;

use App\Models\Promo;
use App\Models\PromoUse;
use App\Models\Transaction;
use App\Models\User;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class PromoUseService {
    /**
    * Apply a promo to a transaction.
    */

    public static function applyPromoToTransaction( int $userId, int $transactionId, int $promoId, array $additionalData = [] ): PromoUse {
        DB::beginTransaction();

        try {
            // Fetch related models
            $user = User::findOrFail( $userId );
            $transaction = Transaction::findOrFail( $transactionId );
            $promo = Promo::findOrFail( $promoId );

            // Save promo usage
            $promoUse = PromoUse::create( [
                'user_id' => $user->id,
                'transaction_id' => $transaction->id,
                'promo_id' => $promo->id,
                'additional_data' => $additionalData,
            ] );

            DB::commit();

            return $promoUse;
        } catch ( \Exception $e ) {
            DB::rollBack();
            throw $e;
        }
    }

    /**
    * Get all promo usages for a specific user.
    */

    public static function getPromoUsesForUser( int $userId ): Collection {
        return PromoUse::where( 'user_id', $userId )->get();
    }

    /**
    * Get all promo usages for a specific promo.
    */

    public static function getPromoUsesForPromo( int $promoId ): Collection {
        return PromoUse::where( 'promo_id', $promoId )->get();
    }

    /**
    * Get all promo uses for a specific transaction.
    */

    public static function getPromoUsesForTransaction( int $transactionId ): Collection {
        return PromoUse::where( 'transaction_id', $transactionId )->get();
    }
}
