<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserVoucherUsage extends Model {
    use HasFactory;

    protected $fillable = [
        'user_id',
        'voucher_id',
        'transaction_id',
        'is_used',
    ];

    protected $casts = ['is_used'];

    /**
    * Get the transaction that this voucher usage belongs to.
    */

    public function transaction() {
        return $this->belongsTo( Transaction::class, 'transaction_id' );
    }

    /**
    * Get the user that this voucher usage belongs to.
    */

    public function user() {
        return $this->belongsTo( User::class );
    }

    /**
    * Get the voucher that this usage relates to.
    */

    public function voucher() {
        return $this->belongsTo( Voucher::class );
    }
}
