<?php

namespace App\Models;

use App\Enums\StatusEnum;
use App\Enums\AffiliatePackageType;
use Illuminate\Database\Eloquent\Model;

class UserAffiliatePackage extends Model {
    protected $fillable = [
        'user_id',
        'affiliate_package_id',
        'status',
    ];

    public function user() {
        return $this->belongsTo( User::class );
    }

    public function affiliatePackage() {
        return $this->belongsTo( AffiliatePackage::class );
    } 

    public function updateStatus( string $status ): bool {
        if ( in_array( $status, StatusEnum::asArray() ) ) {
            $this->status = $status;
            return $this->save();
        }

        return false;
    }
}
