<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserRegistered extends Mailable
 {
    use Queueable, SerializesModels;

    public $user;

    /**
    * Create a new message instance.
    *
    * @param \App\Models\User $user
    * @return void
    */

    public function __construct( User $user )
 {
        $this->user = $user;
    }

    /**
    * Build the message.
    *
    * @return $this
    */

    public function build()
 {
        return $this->view( 'emails.users.registered' )
        ->with( [ 'user' => $this->user ] );
    }
}
