<?php

namespace App\Mail;

use App\Models\Transaction;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TransactionCreated extends Mailable {
    use Queueable, SerializesModels;

    public $transaction;
    public User $user;

    /**
    * Create a new message instance.
    *
    * @param \App\Models\Transaction $transaction
    * @return void
    */

    public function __construct( Transaction $transaction ) {
        $this->user = $transaction->user;
        $this->transaction = $transaction;
    }

    /**
    * Build the message.
    *
    * @return $this
    */

    public function build() {
        return $this->view( 'emails.transactions.created' )
        ->with( [
            'transaction' => $this->transaction,
            'user' => $this->user ] )
            ->subject( 'Transaction Notification' );
        }
    }
