<?php

namespace App\Mail;

use App\Models\Transaction;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ReferralPaidEmail extends Mailable {
    use Queueable, SerializesModels;

    /**
    * Create a new message instance.
    */

    public function __construct( public Transaction $transaction, public User $referred ) {
        //
    }

    /**
    * Get the message envelope.
    */

    public function envelope(): Envelope {
        return new Envelope(
            subject: 'You’ve Earned a Bonus — Thanks for Spreading the Word',
        );
    }

    /**
    * Get the message content definition.
    */

    public function content(): Content {
        return new Content(
            view: 'emails.transactions.referral-bonus-received',
            with:[ 'user' => $this->transaction->user, 'transaction' => $this->transaction , 'referred' => $this->referred]
        );
    }

    /**
    * Get the attachments for the message.
    *
    * @return array<int, \Illuminate\Mail\Mailables\Attachment>
    */

    public function attachments(): array {
        return [];
    }
}
