<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AccountResource extends JsonResource {
    /**
    * Transform the resource into an array.
    *
    * @return array<string, mixed>
    */

    public function toArray( Request $request ): array {
        $account = parent::toArray( $request );

        // Assuming the model has these fields
        $account[ 'has_enabled_2fa' ] = $this->hasEnabledTwoFactorAuthentication();
        $account[ 'twoFAValid' ] = $this->two_factor_verified_at && $this->two_factor_verified_at->floatDiffInSeconds( now() ) <= config( 'auth.twofa_validity', 60 );

        return $account;
    }
}
