<?php

namespace App\Http\Middleware;

use App\Models\SystemSettings;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Require2FA {
    public function handle(Request $request, Closure $next) {
        $response = $next($request);
        $user = Auth::user();

        // Check if 2FA is enforced and the user hasn't verified this session
        $is2FAEnforced = system_setting(SystemSettings::REQUIRE_2FA, false);

        if ($user && $user->two_factor_secret && !$user->two_factor_confirmed_at && $is2FAEnforced) {
            $data = $response->getData(true); // Convert JSON response to array
            $data['require_2fa_code'] = true;
            $response->setData($data);
        }

        return $response;
    }
}
