<?php

namespace App\Http\Middleware;

use App\Models\SystemSettings;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class CheckUserIp {
    public function handle( Request $request, Closure $next ) {
        $user = $request->user();

        if ( !$user ) {
            return $next( $request );
            // no user, skip
        }

        $currentIp = $request->ip();

        if ( $user->ip !== $currentIp && system_setting( SystemSettings::ENABLED_2FA, false ) && $user->hasEnabledTwoFactorAuthentication() ) {
            // IP changed — reset 2FA verification and update IP
            $user->two_factor_verified_at = null;
            $user->ip = $currentIp;
            $user->save();

            // Optionally return 403 or a specific response asking for 2FA again
            return response()->json( [
                'message' => 'New IP detected. Please verify two-factor authentication.',
                'requires_2fa' => true,
            ], 403 );
        }

        return $next( $request );
    }
}
