<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PaymentMethod;
use App\Models\SystemSettings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PaymentMethodController extends Controller {
    public function index() {
        $paymentMethods = PaymentMethod::all();
        return $this->success( $paymentMethods, 'Payment methods retrieved successfully.' );
    }

    public function store( Request $request ) {
        return $this->error( 'You have been restricted from accessing this method', 200 );
        $validator = Validator::make( $request->all(), [
            'short_name' => 'required|string|max:255',
            'network' => 'required|string|max:255',
            'currency' => 'required|string|max:255',
            'address' => 'required|string|max:255',
        ] );

        if ( $validator->fails() ) {
            return $this->error( $validator->errors()->first(), 422, $validator->errors() );
        }

        $user = $request->user();
        if (
            !$user->two_factor_verified_at ||
            $user->two_factor_verified_at->diffInSeconds( now() ) > 5
        ) {
            return $this->error( '2FA expired. Please re-verify.', 403 );
        }

        $paymentMethod = PaymentMethod::create( $request->all() );
        return $this->success( $paymentMethod, 'Payment method created successfully.', 201 );
    }

    public function show( $id ) {
        $paymentMethod = PaymentMethod::find( $id );

        if ( !$paymentMethod ) {
            return $this->error( 'Payment method not found', 404 );
        }

        return $this->success( $paymentMethod, 'Payment method retrieved successfully.' );
    }

    public function update( Request $request, $id ) {
        return $this->error( 'You have been restricted from accessing this method', 200 );
        $paymentMethod = PaymentMethod::find( $id );

        if ( !$paymentMethod ) {
            return $this->error( 'Payment method not found', 404 );
        }

        $validator = Validator::make( $request->all(), [
            'short_name' => 'string|max:255',
            'network' => 'string|max:255',
            'currency' => 'string|max:255',
            'address' => 'string|max:255',
        ] );

        if ( $validator->fails() ) {
            return $this->error( 'Validation error', 422, $validator->errors() );
        }

        $user = $request->user();

        if (
            system_setting( SystemSettings::ENABLED_2FA, false )  &&(! $user->two_factor_verified_at ||
            $user->two_factor_verified_at->diffInSeconds( now() ) > 5)
        ) {
            return $this->error( '2FA expired. Please re-verify.', 403 );
        }

        $paymentMethod->update( $request->all() );
        return $this->success( $paymentMethod, 'Payment method updated successfully.' );
    }

    public function destroy( $id ) {
        return $this->error( 'You have been restricted from accessing this method', 200 );
        $paymentMethod = PaymentMethod::find( $id );

        if ( !$paymentMethod ) {
            return $this->error( 'Payment method not found', 404 );
        }

        $paymentMethod->delete();
        return $this->success( null, 'Payment method deleted successfully.' );
    }
}
