<?php

use App\Models\SystemSettings;

if ( !function_exists( 'exitIF' ) ) {
    /**
    * Break the current execution if the condition is true.
    *
    * @param bool $condition The condition to check.
    * @param mixed $returnValue ( Optional ) The value to return if the condition is true.
    */

    function exitIF( bool $condition, $returnValue = null ): void {
        if ( $condition ) {
            // If a return value is provided, return it
            if ( func_num_args() === 2 ) {
                exit( $returnValue );
            }
            // Otherwise, just stop execution
            exit;
        }
    }
}

if ( !function_exists( 'require_condition' ) ) {
    /**
    * Enforce a required condition.
    *
    * @param bool $condition The condition to check.
    * @param string $errorMessage The error message to throw if the condition is false.
    * @throws \RuntimeException If the condition is false.
    */

    function require_condition( bool $condition, string $errorMessage ): void {
        if ( !$condition ) {
            throw new \RuntimeException( $errorMessage );
        }
    }
}

if ( !function_exists( 'system_setting' ) ) {
    /**
    * Retrieve a system setting value by key, or all settings if no key is provided.
    *
    * @param string|null $key
    * @param mixed $default
    * @return mixed
    */

    function system_setting( $key = null, $default = null ) {
        try {
            $settings =   SystemSettings::pluck( 'value', 'key' )->toArray();
            if ( $key !== null ) {
                return $settings[ $key ] ?? $default;
            }
            return $settings;
        } catch ( \Throwable $th ) {
            //throw $th;
        }
    }
}

if ( !function_exists( 'fetchMetadata' ) ) {
    function fetchMetadata( $mid ) {

        // Fetch the promotional material using the 'mid'
        $promotionalMaterial = \App\Models\PromotionalMaterial::find( $mid );

        // Prepare metadata using the fillable attributes
        $metadata = [
            'title' => $promotionalMaterial->title ?? 'No Title Found',
            'description' => $promotionalMaterial->description ?? 'No Description Found',
            'media_url' => $promotionalMaterial->media_url ?? null,
            'media_type' => $promotionalMaterial->media_type ?? null,
            'link' => url( '/auth?mid=' . $promotionalMaterial->id ),
        ];

        return $metadata;
    }

}
