<?php declare( strict_types = 1 );

namespace App\Enums;

use BenSampo\Enum\Enum;

final class PayoutIntervalEnumSec extends Enum {
    const HOURLY = 3600;
    // 1 hour ( 60 min * 60 sec )
    const DAILY = 86400;
    // 24 hours ( 24 * 60 * 60 )
    const WEEKLY = 432000;
    // 5 weekdays ( 5 * 86400 )
    const MONTHLY = 1900800;
    // 22 weekdays in a month ( 22 * 86400 )
    const YEARLY = 22579200;
    // 261 weekdays in a year ( 261 * 86400 )
}
