<?php declare( strict_types = 1 );

namespace App\Enums;

use BenSampo\Enum\Enum;

/**
* @method static static TransactionCreated()
* @method static static TransactionUpdated()
* @method static static Login()
* @method static static Registration()
* @method static static Generic()
* @method static static AdminTransaction()
* @method static static AdminUserJoin()
* @method static static ReferralJoin()
*/
final class NotificationType extends Enum {
    const TransactionCreated = 'transaction_created';
    const TransactionUpdated = 'transaction_updated';
    const Login = 'login';
    const Generic = 'generic';
    const AdminTransaction = 'admin_transaction';
    const AdminUserJoin = 'admin_user_join';
    const ReferralJoin = 'referral_join';
    const Registration = 'registration';
    const DepositComplimentEmail = 'deposit_compliment_email';
}
