<?php declare( strict_types = 1 );

namespace App\Enums;

use BenSampo\Enum\Enum;

/**
* @method static static NoInvestment()
* @method static static NewWithInvestment()
* @method static static MonoPlan()
* @method static static NoReferral()
* @method static static All()
*/
final class AudienceGroupEnum extends Enum {
    const NoInvestment = 'noinvestment';
    const NewWithInvestment = 'newwithinvestment';
    const MonoPlan = 'monoplan';
    const NoReferral = 'noreferral';
    const All = 'all';

    public static function getDescription( $value ): string {
        return match ( $value ) {
            self::NoInvestment => 'Accounts with no investment',
            self::NewWithInvestment => 'New accounts with investment',
            self::MonoPlan => 'Accounts with mono plans',
            self::NoReferral => 'Accounts with no referral',
            self:: All => 'All user accounts',
            default => parent::getDescription( $value ),
        }
        ;
    }
    
}

