<?php

namespace App\Casts;

use App\AffiliateBenefits;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class AffiliateBenefitsCast implements CastsAttributes {
    public function get( $model, string $key, $value, array $attributes ) {
        return (new AffiliateBenefits( json_decode( $value, true ) ))?->benefits;
        // Deserialize JSON to AffiliateBenefits
    }

    public function set( $model, string $key, $value, array $attributes ) {
        if ( $value instanceof AffiliateBenefits ) {
            return json_encode( $value->getBenefits() );
            // Serialize AffiliateBenefits to JSON
        }

        return json_encode( $value );
        // Default to array
    }
}
