@extends('emails.base')

@section('header', 'Your Investment Is Confirmed — The Robots Are Now in Motion')

@section('slot')
<div class="content">
    Congratulations — your investment has been successfully received and confirmed!
    <div class="highlight">
        <p>📦 Amount Invested: ${{ rtrim(rtrim(number_format($transaction->amount_usd, 2, '.', ''), '0'), '.') }}<br>
            📅 Date: {{ $transaction->updated_at->format('d-m-Y H:i:s') }}<br>
            📈 Investment Plan: {{ $transaction->scheme->scheme_name }}<br>
            ✅ Status: Approved
        </p>
    </div>
    <p>
        You’ve just taken a bold step into the future by sponsoring the production of intelligent robots that are already in high demand. These machines will soon be deployed to real businesses—doing real work, generating real profit.
    </p>
    <p>What happens next?</p>
    <ul class="checklist">
        <li>&bull; Your funds are being used to produce high-precision robots</li>
        <li>&bull; Once deployed, they’ll start generating income</li>
        <li>&bull; You’ll begin earning weekly returns—as early as tomorrow</li>
    </ul>
    <p>
        This is more than an investment—it’s a partnership with innovation. As robots are produced and rented out faster than ever, your decision to act now places you among the early adopters positioned to benefit the most.
    </p>
    You’ve unlocked:
    <ul class="checklist">
        <li>✅ Passive income from real industrial demand</li>
        <li>✅ A growing share in a future-proof business model</li>
        <li>✅ A system designed to profit for the next 100 years</li>
    </ul>
    <p>
        The more robots we deploy, the greater the returns shared with forward-thinking partners like you.
    </p>
    <div class="cta">
        <a href="https://dash.dnxgroup.com/invest">🔁 Click here if you'd like to increase your position</a><br>
        {{-- <a href="#">👥 Refer and Earn Weekly from Their Profits ›</a> --}}
    </div>
    <p>
        We’re excited to have you on this journey. The robots are in action—and your wealth is already in motion.
    </p>
</div>
@endsection
