<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="{{ $title }}">
    <meta property="og:description" content="{{ $description }}">
    <meta property="og:image" content="{{ $media_url }}">
    <meta property="og:type" content="{{ $media_type ?? 'website' }}">
    <meta property="og:url" content="{{ $link }}">

    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $title }}">
    <meta name="twitter:description" content="{{ $description }}">
    <meta name="twitter:image" content="{{ $media_url }}">
    <meta name="twitter:url" content="{{ $link }}">

    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Custom Animation -->
    <style>
        @keyframes fadeInUp {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }

            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fadeInUp {
            animation: fadeInUp 0.8s ease-out;
        }

        @keyframes hoverScale {
            0% {
                transform: scale(1);
            }

            100% {
                transform: scale(1.05);
            }
        }

        .hoverScale {
            animation: hoverScale 0.3s ease-in-out infinite alternate;
        }

        .bg-pattern {
            background-image: url('data:image/svg+xml,%3Csvg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg"%3E%3Cpath fill="none" stroke="%23FFFFFF" stroke-width="1" opacity="0.02" d="M 0 10 L 10 10 L 10 20 L 0 20 Z M 10 10 L 10 0 M 20 0 L 20 10 L 30 10 L 30 0 Z M 20 30 L 20 20 L 30 20 L 30 30 Z M 10 20 L 10 30 L 20 30 L 20 20 Z M 30 30 L 30 20 L 40 20 L 40 30 Z M 40 0 L 40 10 L 30 10 L 30 0 Z"%3E%3C/path%3E%3C/svg%3E');
            background-size: 200px 200px;
            background-position: center;
            background-repeat: repeat;
        }
    </style>
</head>
<body class="bg-black text-neutral-100 flex items-center justify-center min-h-screen bg-pattern text-center">
    <div class="max-w-md bg-neutral-900 shadow-lg rounded-3xl overflow-hidden transform transition duration-300 hover:scale-105 fadeInUp">
        @if ($media_url)
        <div class="relative">
            <img src="{{ $media_url }}" alt="Preview Image" class="w-full object-cover transition-transform transform hover:scale-110 duration-500">
            <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent"></div>
        </div>
        @endif
        <div class="p-4 rounded-t-2xl">
            <h1 class="text-2xl font-bold text-neutral-100 mb-3 fadeInUp">{{ $title }}</h1>
            <p class="text-neutral-300 mb-5 fadeInUp">{{ $description }}</p>
            <a href="{{ $link }}" class="inline-block text-center px-6 py-3 bg-neutral-600 text-white font-semibold rounded-full hover:bg-neutral-700 focus:outline-none focus:ring-2 focus:ring-neutral-500 focus:ring-opacity-50 transition duration-200 w-full">
                Get Started
            </a>
        </div>
    </div>
</body>
</html>
