@extends('emails.base')

@section('header', 'Welcome Back!')

@section('slot')

<!-- Personalized Greeting -->
<p style="font-size: 18px; font-weight: 500; color: #374151; margin-bottom: 20px;">
    Hello {{ $user['first_name'] ?? $user['last_name'] ?? "There" }},
</p>

<!-- Message -->
<p style="font-size: 14px; color: #4b5563; line-height: 1.5;">
    We're excited to see you back at {{ system_setting('site_name') }}! You’ve successfully logged in, and your journey continues with us.
    Whether you're picking up where you left off or exploring new features, we're here to support you every step of the way.
</p>

<!-- Call to Action (CTA) -->
<div style="margin-top: 20px; width:100%; display:flex">
    <a href="{{ system_setting('site_url') }}/dashboard" style="width:100%; text-align:center; padding: 10px 20px; background-color: #10b981; color: #ffffff; text-decoration: none;
               font-size: 14px; border-radius: 9999px; transition: background-color 0.3s;">
        Explore Your Dashboard
    </a>
</div>

<!-- Additional Info -->
<p style="margin-top: 20px; font-size: 14px; color: #4b5563; line-height: 1.5;">
    If you didn’t log in or you notice any suspicious activity, please
    <a href="mailto:{{ system_setting('support_email') }}" style="color: #ef4444; text-decoration: none;">contact us immediately</a>.
</p>

<!-- Thank You Message -->
<p style="margin-top: 20px; font-size: 14px; color: #4b5563; line-height: 1.5;">
    Thank you for being part of the {{ system_setting('site_name') }} community. We’re here to make your experience exceptional.
</p>

<p style="margin-top: 20px; font-size: 14px; color: #4b5563;">With appreciation,</p>
<p style="font-size: 14px; color: #4b5563;">The {{ system_setting('site_name') }} Team</p>

@endsection

