<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('investment_maturity_bonus_tiers', function (Blueprint $table) {
            $table->id();

            $table->foreignId('investment_scheme_id')
                ->nullable()
                ->constrained('investment_schemes');

            $table->string('title');
            $table->text('description')->nullable();
            $table->decimal('min_amount', 18, 2);
            $table->decimal('max_amount', 18, 2)->nullable();

            $table->decimal('bonus_percentage', 8, 4);
            $table->decimal('interest_percentage_on_investment', 8, 4);

            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->unique([
                'investment_scheme_id',
                'min_amount',
                'title',
            ], 'unique_plan_tier');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investment_maturity_bonus_tiers');
    }
};
