<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;



return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up()
    {
        Schema::create('affiliate_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->json('benefits');
            $table->text('description');
            $table->integer('required_referrals_to_join')->default(1);
            $table->boolean('is_system_default')->default(false);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('affiliate_packages');
    }
};
