<?php

use App\Enums\PromoType;
use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('promos', function (Blueprint $table) {
            $table->id();
            $table->string('title'); // Title of the promo
            $table->text('description')->nullable(); // Detailed description
            $table->enum('type', PromoType::asArray()); // Enum for promo type: 'discount' or 'bonus'
            $table->enum('status', StatusEnum::asArray())->default(StatusEnum::PENDING);
            $table->unsignedBigInteger('scheme_id'); // Foreign key to investment schemes
            $table->dateTime('start_date'); // Promo start date
            $table->dateTime('end_date'); // Promo end date
            $table->decimal('discount_or_bonus', 8, 2); // Discount percentage or value (for discount type)
            $table->decimal('start_amount', 15, 2); // Minimum amount required to qualify for the promo
            $table->integer('usage_limit')->default(10000); // Maximum number of uses
            $table->string('media_url')->nullable();
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('scheme_id')
                ->references('id')
                ->on('investment_schemes')
                ->onDelete('cascade')
                ->onUpdate('restrict');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promos');
    }
};
