<?php

namespace App\Observers;

use App\Jobs\EmailJob;
use App\Models\User;

class UserObserver {
    /**
    * Handle the User 'created' event.
    *
    * @param \App\Models\User $user
    * @return void
    */

    public function created( User $user ) {
        // Send email for user registration
        try {
            EmailJob::dispatch( [ 'user' => $user,  'type' => 'registration' ] )->afterCommit();
            // Log::info( 'User registered:', $user->toArray() );
        } catch ( \Throwable $th ) {
            //throw $th;
        }
    }

    /**
    * Handle the User 'logged in' event.
    *
    * @param \App\Models\User $user
    * @return void
    */

    public function loggedIn( User $user ) {
        // Send email for user login
        try {
            EmailJob::dispatch( [ 'user' => $user,  'type' => 'login' ] )->beforeCommit();
            // NotificationService::notifyLoginForUser($user, );
        } catch ( \Throwable $th ) {
            //throw $th;
        }
    }
}
