<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class SystemSettings extends Model implements Auditable {
    use HasFactory, \OwenIt\Auditing\Auditable;

    // Define constants for the setting keys
    public const SITE_NAME = 'site_name';
    public const SITE_URL = 'site_url';
    public const ADMIN_EMAIL = 'admin_email';
    public const SUPPORT_EMAIL = 'support_email';
    public const HEADER_CONTENTS = 'header_contents';
    public const FOOTER_CONTENTS = 'footer_contents';
    public const MAINTENANCE_MODE = 'maintenance_mode';
    public const TERMS_CONDITIONS = 'terms_conditions';
    public const ALLOW_REGISTRATION = 'allow_registration';
    public const MUST_VERIFY_EMAIL = 'must_verify_email';
    public const MUST_BE_APPROVED = 'must_be_approved';
    public const PLATFORM_ADDRESS = 'platform_address';
    public const ADMIN_PHONE = 'admin_phone';
    public const MIN_REINVESTMENT_AMOUNT = 'min_reinvestment_amount';
    public const MIN_TOPUP_PERCENTAGE = 'min_topup_percentage';
    public const ADMIN_WHATSAPP_PHONE = 'admin_whatsapp_phone';
    public const INTEREST_FREQUENCY_HOURS = 'interest_frequency_hours';
    public const MAX_REFERRAL_COMMISSION_LEVEL = 'max_referral_commission_level';
    public const INITIAL_DEPOSIT_BONUS_PERCENTAGE = 'initial_deposit_bonus_percentage';
    public const INITIAL_DEPOSIT_BENEFIT_PERCENTAGE = 'initial_deposit_benefit_percentage';
    public const MIN_REFERRALS_REQUIRED_FOR_CASHOUT = 'min_referrals_required_for_cashout';
    public const MAX_SUB_DEPOSIT_COMMISION_LIMIT = 'max_sub_deposit_commision_limit';
    public const ENABLED_2FA = 'enabled_2fa';
    public const REQUIRE_2FA = 'require_2fa';

    // Additional settings
    // public const DEFAULT_CURRENCY = 'default_currency';
    // public const TIMEZONE = 'timezone';
    // public const LOCALE = 'locale';
    // public const DATE_FORMAT = 'date_format';
    // public const PASSWORD_RESET_EXPIRY = 'password_reset_expiry';
    // public const SESSION_TIMEOUT = 'session_timeout';
    // public const TWO_FACTOR_AUTHENTICATION = 'two_factor_authentication';
    // public const MAX_LOGIN_ATTEMPTS = 'max_login_attempts';
    // public const IP_WHITELIST = 'ip_whitelist';
    // public const MIN_PASSWORD_LENGTH = 'min_password_length';
    // public const DEFAULT_USER_ROLE = 'default_user_role';
    public const MIN_WITHDRAWAL_AMOUNT = 'minimum_withdrawal_amount';
    public const MAX_WITHDRAWAL_AMOUNT = 'maximum_withdrawal_amount';
    public const MAX_PENDING_WITHDRAWALS = 'max_pending_withdrawals';
    // public const TRANSACTION_FEE_PERCENTAGE = 'transaction_fee_percentage';
    // public const MAX_ACCOUNTS_PER_IP = 'max_accounts_per_ip';
    // public const WITHDRAWAL_PROCESSING_TIME = 'withdrawal_processing_time';
    public const NOTIFICATION_EMAIL = 'notification_email';
    public const PREMIUM_DEPOSIT_BONUS = 'premium_deposit_bonus';
    // public const ENABLE_EMAIL_NOTIFICATIONS = 'enable_email_notifications';
    // public const MAX_AFFILIATE_LEVELS = 'max_affiliate_levels';
    // public const MAX_UPLOAD_SIZE_MB = 'max_upload_size_mb';
    // public const CACHE_LIFETIME_MINUTES = 'cache_lifetime_minutes';
    // public const RATE_LIMIT_REQUESTS_PER_MINUTE = 'rate_limit_requests_per_minute';
    // public const PRIVACY_POLICY = 'privacy_policy';
    // public const COOKIE_CONSENT_REQUIRED = 'cookie_consent_required';
    // public const MAX_FAILED_VERIFICATION_ATTEMPTS = 'max_failed_verification_attempts';

    protected $fillable = [
        'key',
        'value',
    ];

    protected $casts = [
        self::MUST_VERIFY_EMAIL => 'bool',
    ];

    protected $booleanSettings = [
        self::MAINTENANCE_MODE,
        self::ALLOW_REGISTRATION,
        self::MUST_VERIFY_EMAIL,
        self::MUST_BE_APPROVED,
        // self::TWO_FACTOR_AUTHENTICATION,
        // self::ENABLE_EMAIL_NOTIFICATIONS,
        // self::COOKIE_CONSENT_REQUIRED,
    ];

    public static function getSetting( $key, $default = null ) {
        $setting = self::where( 'key', $key )->first();
        return $setting ? $setting->value : $default;
    }

    public static function updateSetting( $key, $value ) {
        return self::updateOrCreate(
            [ 'key' => $key ],
            [ 'value' => $value ]
        );
    }

    public static function updateSettings( array $settings ) {
        foreach ( $settings as $key => $value ) {
            if ( in_array( $key, ( new self )->booleanSettings ) ) {
                $value = filter_var( $value, FILTER_VALIDATE_BOOLEAN );
            }

            if ( is_array( $value ) ) {
                self::updateNestedSettings( $key, $value );
            } else {
                self::updateSetting( $key, $value );
            }
        }

        return $settings;
    }

    private static function updateNestedSettings( string $prefix, array $nestedSettings ) {
        foreach ( $nestedSettings as $key => $value ) {
            $compositeKey = $prefix . '_' . $key;
            if ( is_array( $value ) ) {
                self::updateNestedSettings( $compositeKey, $value );
            } else {
                self::updateSetting( $compositeKey, $value );
            }
        }
    }
}
