<?php

namespace App\Mail;

use App\Models\Transaction;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SendAdminNotification extends Mailable {
    use Queueable, SerializesModels;

    public $user;
    public Transaction $transaction;
    public $userMessage;

    /**
    * Create a new message instance.
    *
    * @param  $user
    * @param  string $transactionId
    * @param  string|null $userMessage
    */

    public function __construct( $user, Transaction $transaction, ?string $userMessage = null ) {
        $this->user = $user;
        $this->transaction = $transaction;
        $this->userMessage = $userMessage;
    }

    /**
    * Get the message envelope.
    */

    public function envelope(): Envelope {
        return new Envelope(
            subject: 'Transaction Notification from ' . $this->user->name,
        );
    }

    /**
    * Get the message content definition.
    */

    public function content(): Content {
        return new Content(
            view: 'emails.notifications.admin-notification',
            with: [
                'user' => $this->user,
                'transactionId' => $this->transaction->id,
                'userMessage' => $this->userMessage,
            ]
        );
    }

    /**
    * Get the attachments for the message.
    *
    * @return array<int, \Illuminate\Mail\Mailables\Attachment>
    */

    public function attachments(): array {
        return [];
    }
}
