<?php

namespace App\Http\Requests\Api;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;
use UserType;

class AuthLoginRequest extends FormRequest {
    /**
    * Determine if the user is authorized to make this request.
    */

    public function authorize(): bool {
        $email = request()[ 'email' ];
        $user = User::where( 'email', $email )->first();
        $isAuthoreized = system_setting( 'maintenance_mode', false ) == false;
        if ( $user && in_array( $user->role,  [ 'ADMIN' ] ) ) {
            $isAuthoreized = true;
        }
        return $isAuthoreized;
    }

    /**
    * Get the validation rules that apply to the request.
    *
    * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
    */

    public function rules(): array {
        return [
            'email' => 'required|string|email|max:255',
            'password' => 'required|string',
        ];
    }
}
