<?php

namespace App\Http\Middleware;

use App\Models\SystemSettings;
use Closure;
use Illuminate\Http\Request;

class Ensure2FAEnabled
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $user = $request->user();
        $is2FAEnabled = config(SystemSettings::ENABLED_2FA, true);

        // If 2FA is enforced but the user hasn't enabled it, modify response data
        if ($is2FAEnabled && in_array($request->method(), ['GET']) && !$user->hasEnabledTwoFactorAuthentication()) {
            $data = $response->getData(true);
            $data['should_enable_2fa'] = true;
            $response->setData($data);
        }

        return $response;
    }
}
