<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminMiddleware {
    public function handle( Request $request, Closure $next ) {
        // Get authenticated user
        $user = $request->user( );

        // Determine admin status
        $isAdmin = optional( $user )->role === 'ADMIN';
        // Make available as request property ( for request()->isAdmin )
        $request->merge( [ 'isAdmin' => $isAdmin ] );
        $request->attributes->set( 'isAdmin', $isAdmin );

        // Authorization check
        if ( !$isAdmin ) {
            return response()->json( [ 'error' => 'Unauthorized' ], 403 );
        }

        return $next( $request );
    }
}
