<?php declare( strict_types = 1 );

namespace App\Enums;

use BenSampo\Enum\Enum;

/**
* @method static static MANAGEMENT_FEE()
* @method static static ROBOTS_LOGISTIC_FEE()
* @method static static ADMINISTRATION_FEE()
* @method static static PREMIUM_INSURANCE_FEE()
* @method static static WITHDRAWAL_TRANSACTION_FEE()
* @method static static EARLY_TERMINATION_FEE()
*/
final class FeeVariantEnum extends Enum {
    const MANAGEMENT_FEE = 'management_fee';
    const ROBOTS_LOGISTIC_FEE = 'robots_logistic_fee';
    const ADMINISTRATION_FEE = 'administration_fee';
    const PREMIUM_INSURANCE_FEE = 'premium_insurance_fee';
    const WITHDRAWAL_TRANSACTION_FEE = 'withdrawal_transaction_fee';
    const EARLY_TERMINATION_FEE = 'early_termination_fee';
}
