@extends('emails.base')

@section('header', 'You’ve Earned a Bonus — Thanks for Spreading the Word')

@section('slot')
<div class="content">
    Great news — your referral has joined DNX, and you’ve just earned a bonus for sharing the future!
    <div class="highlight">
        <p>
            🎉 Referral Bonus Credited: ${{ rtrim(rtrim(number_format($transaction->amount_usd, 2, '.', ''), '0'), '.') }}<br>
            👤 New Member Referred: {{ $referred->first_name }} {{ $referred->last_name }}<br>
            📅 Date: {{ $transaction->created_at->format('d-m-Y H:i:s') }}<br>
        </p>
    </div>
    <p>
        Thank you for introducing someone to a smarter way of investing. Because of your effort, more people are now earning from robots doing real work in real industries — and you’re being rewarded for it.
    </p>
    Why this matters:
    <ul class="checklist">
        <li>• ✅ You earn weekly bonuses from your referrals' profits</li>
        <li>• ✅ The more people you refer, the more your network earns — and so do you</li>
        <li>• ✅ You’re building a stream of automated income that grows as your network grows</li>
    </ul>

    <p>
        This is just the beginning. Many of our top referrers earn $500 to $20,000 weekly by doing exactly what you’ve done — sharing a life-changing opportunity.
    </p>
    <div class="cta">
        <a href="#">📈 Want to earn more? Share your link again ›</a>
    </div>
    <p>
        Once again, congratulations! Your network is growing, and your returns are following right behind.
        To your continued success,
    </p>
</div>

@endsection
